package com.allinpay.ystpay.sample.v1.trans.async;

import java.util.Map;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.exception.SdkException;

/**
 * Desc:异步消息处理demo 接收异步消息需要部署http服务 demo使用spring mvc开发http服务端
 **/
@RestController
public class AsyncMessageHandDemo
{

    /**
     * 接收异步消息的服务 messageBody：消息体
     */
    @RequestMapping("/asyncMessageHand")
    public String print(@RequestBody String messageBody)
    {

        System.out.println("接收到异步消息：" + messageBody);
        JSONObject messageObject = JSON.parseObject(messageBody);
        // 推送的交易类型
        String transCode = messageObject.getString("transCode");
        Map<String, Object> data = null;
        try
        {
            data = BasePayClient.verifySign(messageObject);
        }
        catch (SdkException e)
        {
            System.out.println(e.getMessage());
            return "fail";
        }
        // 业务处理
        processNotify(transCode, data);
        return "success";
    }

    private void processNotify(String transCode, Map<String, Object> data)
    {
        System.out.println("回调处理");
    }

}
