package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankFundAllocationReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BankFundAllocationDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行资金调拨通联
        BankFundAllocationReq bankFundAllocationReq = new BankFundAllocationReq();
        //商户订单号
        bankFundAllocationReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //开户银行编号
        bankFundAllocationReq.setOpenBankNo("1009");
        //调拨资金
        bankFundAllocationReq.setOrderAmount(new Long(100));
        //后台通知地址
        bankFundAllocationReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //扩展参数
        bankFundAllocationReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(bankFundAllocationReq);
        System.out.println(response);
    }
}
