package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankSubAcctPaymentReq;
import com.allinpay.ystpay.sdk.core.request.BankSubAcctWithdrawCashReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BankSubAcctPaymentDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行子账户支付
        BankSubAcctPaymentReq bankSubAcctPaymentReq = new BankSubAcctPaymentReq();
        //商户业务订单号
        bankSubAcctPaymentReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户业务子订单号
        bankSubAcctPaymentReq.setReqSubTraceNum("202509021343004517");
        //付款商户会员编号（资金转出方）
        bankSubAcctPaymentReq.setPayerSignNum("202503126");
        //付款商户银行子账号
        bankSubAcctPaymentReq.setPayerSubAcctNo("8870530200354003");
        //付款商户会员名称
        bankSubAcctPaymentReq.setPayerName("王三华");
        //收款商户会员编号
        bankSubAcctPaymentReq.setReceiverSignNum("202503126");
        //收款商户银行子账号
        bankSubAcctPaymentReq.setReceiverSubAcctNo("8870530200354002");
        //收款商户会员名称
        bankSubAcctPaymentReq.setReceiverName("王三华");
        //收款用户收款金额
        bankSubAcctPaymentReq.setReceiveAmount(new Long(100));
        //交易金额
        bankSubAcctPaymentReq.setTradeAmount(new Long(100));
        //平台商户自有资金交易类型
        bankSubAcctPaymentReq.setSelfFlag("D");
        //平台商户自有资金交易金额
        bankSubAcctPaymentReq.setSelfAmount(new Long(50));
        //资金类型/商品信息
        bankSubAcctPaymentReq.setFundType("商品信息");
        //备注
        bankSubAcctPaymentReq.setRemark("");
        Map<String, Object> response = BasePayClient.request(bankSubAcctPaymentReq);
        System.out.println(response);
    }
}