package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankSubAcctPaymentRefundReq;

import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BankSubAcctPaymentRefundDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行子账户支付退款
        BankSubAcctPaymentRefundReq bankSubAcctPaymentRefundReq = new BankSubAcctPaymentRefundReq();
        //退款订单号
        bankSubAcctPaymentRefundReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //退款子订单号
        bankSubAcctPaymentRefundReq.setReqSubTraceNum("");
        //原通联订单号
        bankSubAcctPaymentRefundReq.setOriRespTraceNum("20250416145205208101284540");
        //原支付交易付款用户编号（资金转入方）
        bankSubAcctPaymentRefundReq.setReceiverSignNum("dq-xwbank1020");
        //原支付交易付款用户银行子账号
        bankSubAcctPaymentRefundReq.setReceiverSubAcctNo("8870530200353806");
        //原支付交易付款用户名称（资金转入方）
        bankSubAcctPaymentRefundReq.setReceiverName("广州市白云区均禾鑫成商贸部(个体工商户)");
        //原支付交易收款用户编号（资金转出方）
        bankSubAcctPaymentRefundReq.setPayerSignNum("202503126");
        //原支付交易收款用户银行子账号
        bankSubAcctPaymentRefundReq.setPayerSubAcctNo("8870530200354002");
        //原支付交易收款用户名称（资金转出方）
        bankSubAcctPaymentRefundReq.setPayerName("王三华");
        //原支付交易收款用户退款金额
        bankSubAcctPaymentRefundReq.setReceiveAmount(new Long(100));
        //交易金额
        bankSubAcctPaymentRefundReq.setTradeAmount(new Long(100));
        //收款人列表
//        JSONArray receiverList =new JSONArray();
//        JSONObject rl = new JSONObject();
//        rl.put("receiveAmount",new Long(100));
//        rl.put("platSepTraceNum","1");
//        rl.put("receiverSubAcctNo","8870530200353806");
//        rl.put("receiverName","receiverName");
//        rl.put("receiverSignNum","dq-xwbank1020");
//        receiverList.add(rl);
//        bankSubAcctPaymentRefundReq.setReceiverList(receiverList);
        //平台商户自有资金交易类型
        bankSubAcctPaymentRefundReq.setSelfFlag("N");
        //平台商户自有资金交易金额
        bankSubAcctPaymentRefundReq.setSelfAmount(new Long(50));
        //资金类型/商品信息
        bankSubAcctPaymentRefundReq.setFundType("");
        //备注
        bankSubAcctPaymentRefundReq.setRemark("");
        Map<String, Object> response = BasePayClient.request(bankSubAcctPaymentRefundReq);
        System.out.println(response);
    }
}