package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.ConsumptionApplicationReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class ConsumptionApplicationDemo  extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建消费申请
        ConsumptionApplicationReq consumptionApplicationReq = new ConsumptionApplicationReq();
        //商户会员编号-付款人
        consumptionApplicationReq.setSignNum("JACK2024023005");
        //商户会员编号-收款人
        consumptionApplicationReq.setReceiverSignNum("20241010f4");
        //商户订单号
        consumptionApplicationReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //订单金额
        consumptionApplicationReq.setOrderAmount(new Long(100));
        //支付金额
        consumptionApplicationReq.setPayAmount(new Long(100));
        //营销金额
        consumptionApplicationReq.setPromotionAmount(new Long(0));
        //平台抽佣金额
        consumptionApplicationReq.setCouponAmount(new Long(0));
        //支付模式
        JSONObject parParams = new JSONObject();
        parParams.put("bankCardNo", "");
        parParams.put("agreementNo", "AIP621924021908F149B6F");
        parParams.put("validate", "");
        parParams.put("cvv2", "");
        parParams.put("remark", "");

        PayMode paymode = new PayMode("QUICKPAY_SFT",parParams);
        consumptionApplicationReq.setPayMode(paymode);
        //分账规则来源
        consumptionApplicationReq.setSepDetailSource("");
        //交易验证方式
        consumptionApplicationReq.setVerifyType("");
        //分账规则
//        JSONArray sepDetail = new JSONArray();
//        JSONObject sd = new JSONObject();
//        //商户会员编号
//        sd.put("signNum", "gejunqing");
//        //分账金额
//        sd.put("amount", new Long(100));
//        //备注
//        sd.put("remark", "");
//        sepDetail.add(sd);
//        consumptionApplicationReq.setSepDetail(sepDetail);
        //前台通知地址
        consumptionApplicationReq.setReqsUrl("");
        //后台通知地址
        consumptionApplicationReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //订单过期时间 格式：yyyy-MM-dd HH:mm:ss
        consumptionApplicationReq.setOrderValidTime("2025-09-28 12:00:00");
        //商户类型
        consumptionApplicationReq.setGoodsType("");
        //商户商品编号
        consumptionApplicationReq.setBizGoodsNo("bizGoodsNo123456");
        //商品名称
        consumptionApplicationReq.setGoodsName("测试");
        //摘要
        consumptionApplicationReq.setSummary("");
        //扩展参数
        consumptionApplicationReq.setExtendParams("");
        //交易所在省市
        consumptionApplicationReq.setTxDistrictCode("11");
        //商品描述
//        consumptionApplicationReq.setGoodsDesc("");

        Map<String, Object> response = BasePayClient.request(consumptionApplicationReq);
        System.out.println(response);
    }
}
