package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.OfflineAgreementFileUploadReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class OfflineAgreementFileUploadDemo extends BaseDemo{
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建线下协议文件上传
        OfflineAgreementFileUploadReq offlineAgreementFileUploadReq = new OfflineAgreementFileUploadReq();
        //商户会员编号
        offlineAgreementFileUploadReq.setSignNum("JACK20240520202");
        //请求流水号
        offlineAgreementFileUploadReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //签约会员名称
        offlineAgreementFileUploadReq.setMemberName("竹溪县子怡鞋店");
        //协议类型
        offlineAgreementFileUploadReq.setAgreementType("1");
        //签约协议信息
        JSONObject agreementJson=new JSONObject();

        if ("1".equals(offlineAgreementFileUploadReq.getAgreementType())){
            //签约会员的收款协议文件token
            agreementJson.put("payeeAgreeToken","3320240402161775081384822616065");
            //签约会员的账户提现协议文件token
            agreementJson.put("withdrawAgreeToken","3320240228181762792426705252354");
            //签约会员的授权委托协议信息
            JSONObject authPerAgreeInfo = new JSONObject();
            //被授权人手机号
            authPerAgreeInfo.put("authPhone","15150689571");
            //被授权人姓名
            authPerAgreeInfo.put("authPerName","测试test");
            //被授权人证件号 SM4加密
            authPerAgreeInfo.put("authPerCerNum","4f4558a0215b19977c3670db2de59cb79fb11ce622839ed0ee3efa76fb433aa6");
            //被授权人证件类型
            authPerAgreeInfo.put("authPerCerType","2");
            //签约会员的授权委托协议文件token
            authPerAgreeInfo.put("authPerAgreeToken","3320240402161775080930147479554");

            agreementJson.put("authPerAgreeInfo",authPerAgreeInfo);
            agreementJson.put("sepMemBusCode","20240513-1020-test02");
            agreementJson.put("sepMemName","竹溪县子怡鞋店");
            agreementJson.put("sepWay","1");
            agreementJson.put("sepRateOrAmt","79.99");
            agreementJson.put("sepAgreeToken","3320240228181762792426705252354");
            agreementJson.put("sepwithdrawAgreeToken","3320240228181762792426705252354");

            JSONObject sepAuthPerAgreeInfo = new JSONObject();
            sepAuthPerAgreeInfo.put("authPhone","18120129571");
            sepAuthPerAgreeInfo.put("authPerName","测试分账人");
            sepAuthPerAgreeInfo.put("authPerCerNum","4f4558a0215b19977c3670db2de59cb79fb11ce622839ed0ee3efa76fb433aa6");
            sepAuthPerAgreeInfo.put("authPerCerType","1");
            sepAuthPerAgreeInfo.put("authPerAgreeToken","3320240327131772851176652664834");
            agreementJson.put("sepAuthPerAgreeInfo",sepAuthPerAgreeInfo);

            offlineAgreementFileUploadReq.setAgreementJson(agreementJson);
        } else if ("2".equals(offlineAgreementFileUploadReq.getAgreementType())) {
            //通联支付账户服务协议文件token
            agreementJson.put("payAcctNoOpenAgreeToken","");
            //客户业务合作确认函文件token
            agreementJson.put("coopConfirmToken","");
            //非自然人客户受益所有人信息登记表文件token
            agreementJson.put("nonNatureCusBenefitToken","");

            offlineAgreementFileUploadReq.setAgreementJson(agreementJson);
        }

            //签约结果通知地址
        offlineAgreementFileUploadReq.setNotifyUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        Map<String, Object> response = BasePayClient.request(offlineAgreementFileUploadReq);
        System.out.println(response);
    }
}
