package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.GuaranteeConsumptionReq;
import com.allinpay.ystpay.sdk.core.request.OrderGuaranteeConfirmReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class OrderGuaranteeConfirmDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建单订单担保确认
        OrderGuaranteeConfirmReq orderGuaranteeConfirmReq = new OrderGuaranteeConfirmReq();
        //商户订单号
        orderGuaranteeConfirmReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //担保消费申请商户订单号
        orderGuaranteeConfirmReq.setOrgReqTraceNum("");
        //担保消费申请订单创建日期
        orderGuaranteeConfirmReq.setOriTransDate("");
        //担保消费申请通联订单号
        orderGuaranteeConfirmReq.setOrgRespTraceNum("20250827120109105100307101");
        //收款人列表
        JSONArray receiverList =new JSONArray();
        JSONObject rl = new JSONObject();
        //商户会员编号
        rl.put("signNum","gejunqing");
        //收款金额
        rl.put("amount",new Long(100));
        receiverList.add(rl);
        orderGuaranteeConfirmReq.setReceiverList(receiverList);
        //后台通知地址
        orderGuaranteeConfirmReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //摘要
        orderGuaranteeConfirmReq.setSummary("");
        //扩展参数
        orderGuaranteeConfirmReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(orderGuaranteeConfirmReq);
        System.out.println(response);
    }
}