package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.PersonalPaymentAccountOpenReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class PersonalPaymentAccountOpenDemo extends BaseDemo
{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        // 构建个人支付账户开户H5
        PersonalPaymentAccountOpenReq personalPaymentAccountOpenReq = new PersonalPaymentAccountOpenReq();
        // 请求流水号
        personalPaymentAccountOpenReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        // 商户会员号
        personalPaymentAccountOpenReq.setSignNum("WX202409260001");
        // 个人会员支付账户开户结果通知地址
        personalPaymentAccountOpenReq.setNotifyUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        // 前端回调地址
        personalPaymentAccountOpenReq.setJumpUrl("");

        Map<String, Object> response = BasePayClient.request(personalPaymentAccountOpenReq);
        System.out.println(response);
    }
}
