package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.RechargeApplicationReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class RechargeApplicationDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建充值申请
        RechargeApplicationReq rechargeApplicationReq = new RechargeApplicationReq();
        //充值会员编号
        rechargeApplicationReq.setReceiverSignNum("#yunBizUserId_B2C#");
        //账户类型
        rechargeApplicationReq.setPlatAcctType("00");
        //付款人会员编号
        rechargeApplicationReq.setSignNum("gejunqing");
        //商户订单号
        rechargeApplicationReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //订单金额
        rechargeApplicationReq.setOrderAmount(new Long(100));
        //支付金额
        rechargeApplicationReq.setPayAmount(new Long(100));
        //营销金额
        rechargeApplicationReq.setPromotionAmount(new Long(0));
        //抽佣金额
        rechargeApplicationReq.setCouponAmount(new Long(0));
        //是否处理渠道手续费
        //rechargeApplicationReq.setIsHandleChannelFee("");
        //支付模式
        JSONObject parParams = new JSONObject();
        parParams.put("bankCardNo", "");
        parParams.put("agreementNo", "AIP621924021908F149B6F");
        parParams.put("validate", "");
        parParams.put("cvv2", "");
        parParams.put("remark", "");

        PayMode paymode = new PayMode("QUICKPAY_SFT",parParams);
        rechargeApplicationReq.setPayMode(paymode);
        //前台通知地址
        rechargeApplicationReq.setReqsUrl("");
        //后台通知地址
        rechargeApplicationReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //订单过期时间 格式：yyyy-MM-dd HH:mm:ss
        rechargeApplicationReq.setOrderValidTime("2025-05-31 00:00:00");
        //商品名称
        rechargeApplicationReq.setGoodsName("测试");
        //商品描述
//        rechargeApplicationReq.setGoodsDesc("");
        //交易所在省市
        rechargeApplicationReq.setTxDistrictCode("");
        //摘要
        rechargeApplicationReq.setSummary("");
        //扩展参数
        rechargeApplicationReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(rechargeApplicationReq);
        System.out.println(response);
    }
}
