package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.TransferApplicationReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class TransferApplicationDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建转账申请
        TransferApplicationReq transferApplicationReq = new TransferApplicationReq();
        //商户订单号
        transferApplicationReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号-转出方
        transferApplicationReq.setSignNum("yunBizUserId_B2C#");
        //转出账户类型
        transferApplicationReq.setAcctType("");
        //支付账户号-转出方
        transferApplicationReq.setAcctNum("");
        //商户会员编号-转入方
        transferApplicationReq.setInSignNum("202402230001");
        //支付账户类型-转入方
        transferApplicationReq.setInAcctType("");
        //支付账户号-转入方
        transferApplicationReq.setInAcctNum("");
        //订单金额
        transferApplicationReq.setOrderAmount(new Long(100));
        //后台通知地址
        transferApplicationReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //摘要
        transferApplicationReq.setSummary("");
        //扩展参数
        transferApplicationReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(transferApplicationReq);
        System.out.println(response);
    }
}
