package com.allinpay.ystpay.sample.apidoc;

import com.alibaba.fastjson.JSON;
import com.allinpay.ystpay.apidoc.parser.YstPayAnnotationParser;
import com.allinpay.ystpay.apidoc.parser.YstPayApiMeta;
import com.allinpay.ystpay.apidoc.parser.db.DBConvertor;
import com.allinpay.ystpay.apidoc.parser.db.DBOperator;
import com.allinpay.ystpay.apidoc.parser.db.DbConfigs;
import com.allinpay.ystpay.apidoc.parser.db.entity.ApiDebugApiInfo;
import com.allinpay.ystpay.apidoc.parser.db.entity.ApiDebugDemoCode;
import com.allinpay.ystpay.apidoc.parser.db.entity.ApiDebugDoc;
import com.allinpay.ystpay.apidoc.parser.db.mapper.ApiDebugApiInfoMapper;
import com.allinpay.ystpay.apidoc.parser.db.mapper.ApiDebugDemoCodeMapper;
import com.allinpay.ystpay.apidoc.parser.db.mapper.ApiDebugDocMapper;
import com.allinpay.ystpay.apidoc.parser.language.DemoCode;
import com.allinpay.ystpay.apidoc.parser.language.JavaDemoProvider;
import com.allinpay.ystpay.apidoc.parser.language.NodeJSDemoProvider;

import java.util.ArrayList;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        DBOperator dbOperator = new DBOperator(getDbConfigs());
        updateApiDebugApiInfo(dbOperator);
        updateApiDebugDoc(dbOperator);
        updateApiDebugDemoCode(dbOperator);
    }

    // 更新 api_debug_api_info 表
    private static void updateApiDebugApiInfo(DBOperator dbOperator) {
        String packageName = "com.allinpay.ystpay.sdk.core.request";

        YstPayAnnotationParser annotationParser = new YstPayAnnotationParser();
        List<YstPayApiMeta> apiMetaList = annotationParser.parseApiAnnotations(packageName);

        List<ApiDebugApiInfo> apiDebugApiInfoList = DBConvertor.convertToApiDebugApiInfo(apiMetaList);
        dbOperator.clearTable(ApiDebugApiInfoMapper.class);
        dbOperator.insertIntoTable(ApiDebugApiInfoMapper.class, apiDebugApiInfoList);
    }

    // 更新 api_debug_api_info 表
    private static void updateApiDebugDoc(DBOperator dbOperator) {
        List<ApiDebugApiInfo> apiDebugApiInfoList = dbOperator.queryItems(ApiDebugApiInfoMapper.class);
        List<ApiDebugDoc> apiDebugDocList = dbOperator.queryItems(ApiDebugDocMapper.class);

        List<ApiDebugDoc> updatedItems = DBConvertor.convertToApiDebugDoc(apiDebugDocList, apiDebugApiInfoList);

        dbOperator.clearTable(ApiDebugDocMapper.class);
        dbOperator.insertIntoTable(ApiDebugDocMapper.class, updatedItems);
    }

    // 更新 api_debug_demo_code 表
    private static void updateApiDebugDemoCode(DBOperator dbOperator) {
        List<ApiDebugApiInfo> apiDebugApiInfoList = dbOperator.queryItems(ApiDebugApiInfoMapper.class);

        // Java
        String reqFilePath = "/Users/zhen/Documents/S001_Code/allinpay_git/java/yst-sdk-parent/ystpay-java-sdk/src/main/java/com/allinpay/ystpay/sdk/core/request";
        String demoFilePath = "/Users/zhen/Documents/S001_Code/allinpay_git/java/yst-sdk-parent/ystpay-java-sdk-sample/src/main/java/com/allinpay/ystpay/sample/v1/trans";
        JavaDemoProvider javaDemoProvider = new JavaDemoProvider(reqFilePath, demoFilePath);
        List<DemoCode> javaDemoCodes = javaDemoProvider.getDemoCodes();

        // NodeJS
        NodeJSDemoProvider nodeJSDemoProvider = new NodeJSDemoProvider(apiDebugApiInfoList);
        List<DemoCode> nodeJSDemoCodes = nodeJSDemoProvider.getDemoCodes();

        // 合并
        List<DemoCode> demoCodes = new ArrayList<>();
        demoCodes.addAll(javaDemoCodes);
        demoCodes.addAll(nodeJSDemoCodes);

        List<ApiDebugDemoCode> apiDebugDemoCodes = DBConvertor.convertToApiDebugDemoCode(demoCodes, apiDebugApiInfoList);

        dbOperator.clearTable(ApiDebugDemoCodeMapper.class);
        dbOperator.insertIntoTable(ApiDebugDemoCodeMapper.class, apiDebugDemoCodes);
    }

    public static DbConfigs getDbConfigs() {
//        DbConfigs dbConfigs = new DbConfigs();
//        dbConfigs.setDriver("com.mysql.cj.jdbc.Driver");
//        dbConfigs.setUrl("jdbc:mysql://192.168.40.29:12307/yun_pro_dev?useSSL=false&useUnicode=true&characterEncoding=utf8&allowMultiQueries=true");
//        dbConfigs.setUsername("app");
//        dbConfigs.setPassword("App@321");
//        return dbConfigs;

        DbConfigs dbConfigs = new DbConfigs();
        dbConfigs.setDriver("com.mysql.cj.jdbc.Driver");
        dbConfigs.setUrl("jdbc:mysql://localhost:3306/yun_pro_dev?useSSL=false&useUnicode=true&characterEncoding=utf8&allowMultiQueries=true");
        dbConfigs.setUsername("root");
        dbConfigs.setPassword("qwe@123");
        return dbConfigs;
    }
}
