package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankAccountTransDataChargeReq;
import com.allinpay.ystpay.sdk.core.request.IndustryOrderReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BankAccountTransDataChargeDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行账户交易数据处理费扣收
        BankAccountTransDataChargeReq bankAccountTransDataChargeReq = new BankAccountTransDataChargeReq();
        //请求流水号
        bankAccountTransDataChargeReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //手续费收取模式
        bankAccountTransDataChargeReq.setChargeMode("1");
        //后台通知地址
        bankAccountTransDataChargeReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //手续费收费详情
        JSONObject chargeDetail = new JSONObject();
        //银行结算渠道编号
        chargeDetail.put("settleChannel","1014");
        //渠道资金结算日期（实际结算到银行的日期）
        chargeDetail.put("settleDate","20250902");
        //结算入金金额（分）
        chargeDetail.put("amount",new Long(100));
        //手续费金额（分）
        chargeDetail.put("fee",new Long(10));
        //银行侧资金类型（6位数字）
        chargeDetail.put("fundType","234535");
        bankAccountTransDataChargeReq.setChargeDetail(chargeDetail);

        Map<String, Object> response = BasePayClient.request(bankAccountTransDataChargeReq);
        System.out.println(response);
    }
}