package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankSubAcctDeailQueryReq;
import com.allinpay.ystpay.sdk.core.request.BankUserAddBindCardAppReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BankSubAcctDeailQueryDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行子账户账务明细查询
        BankSubAcctDeailQueryReq bankSubAcctDeailQueryReq = new BankSubAcctDeailQueryReq();
        //商户请求流水号
        bankSubAcctDeailQueryReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        bankSubAcctDeailQueryReq.setSignNum("#yunBizUserId_B2C#");
        //银行子账号
        bankSubAcctDeailQueryReq.setSubAcctNo("");
        //平台登记簿类型
        bankSubAcctDeailQueryReq.setRegisterAttr("01");
        //查询日期
        bankSubAcctDeailQueryReq.setDateStart("20250101");
        //结束日期
        bankSubAcctDeailQueryReq.setDateEnd("20250103");
        //交易类型
        bankSubAcctDeailQueryReq.setQryTradeType("01");
        //查询条数
        bankSubAcctDeailQueryReq.setReturnRows("50");
        //页数
        bankSubAcctDeailQueryReq.setPage("1");

        Map<String, Object> response = BasePayClient.request(bankSubAcctDeailQueryReq);
        System.out.println(response);
    }
}