package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankFundAllocationReq;
import com.allinpay.ystpay.sdk.core.request.BankSubAcctWithdrawCashReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BankSubAcctWithdrawCashDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行子账户提现申请
        BankSubAcctWithdrawCashReq bankSubAcctWithdrawCashReq = new BankSubAcctWithdrawCashReq();
        //商户订单号
        bankSubAcctWithdrawCashReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        bankSubAcctWithdrawCashReq.setSignNum("#yunBizUserId_B2C#");
        //银行子账号
        bankSubAcctWithdrawCashReq.setSubAcctNo("");
        //订单金额
        bankSubAcctWithdrawCashReq.setTradeAmount(new Long(100));
        //后台通知地址
        bankSubAcctWithdrawCashReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //支付模式
        bankSubAcctWithdrawCashReq.setPayMode("WITHDRAW_BANK");
        //银行卡号
        bankSubAcctWithdrawCashReq.setAcctNum("");
        //显示付款账号
        bankSubAcctWithdrawCashReq.setShowPayerAcctNo("");
        //显示付款户名
        bankSubAcctWithdrawCashReq.setShowPayerAcctName("");
        //账户名
        bankSubAcctWithdrawCashReq.setAcctName("");
        //摘要
        bankSubAcctWithdrawCashReq.setSummary("");
        //扩展信息
        bankSubAcctWithdrawCashReq.setExtendParams("");
        Map<String, Object> response = BasePayClient.request(bankSubAcctWithdrawCashReq);
        System.out.println(response);
    }
}