package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BankUserAddBindCardAppReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BankUserAddBindCardAppDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建银行用户新增绑卡申请
        BankUserAddBindCardAppReq bankUserAddBindCardAppReq = new BankUserAddBindCardAppReq();
        //商户请求流水号
        bankUserAddBindCardAppReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        bankUserAddBindCardAppReq.setSignNum("202503126");
        //银行子账号
        bankUserAddBindCardAppReq.setSubAcctNo("8870530200354002");
        //银行账户信息
        JSONObject bankAcctDetail = new JSONObject();
        //账户类型
        bankAcctDetail.put("acctAttr","0");
        //账号
        bankAcctDetail.put("acctNum","177db6c60a04452ab13ef105935d8c3b8414d8e60f76f8a1617e7c73db61aa23");
        //银行预留手机
        bankAcctDetail.put("bankReservePhone","12312341234");
        //银行代码
        bankAcctDetail.put("openBankNo","03080000");
        //开户行支行名称
        bankAcctDetail.put("openBankBranchName","测试银行南京分行测试1111");
        //支付行号
        bankAcctDetail.put("payBankNumber","102655030396");
        //开户行所在省
        bankAcctDetail.put("openBankProvince","江苏");
        //开户行所在市
        bankAcctDetail.put("openBankCity","南京");
        bankUserAddBindCardAppReq.setBankAcctDetail(bankAcctDetail);

        //银行账户信息（bankAcctExtInfo）
        //JSONObject bankAcctExtInfo = new JSONObject();
        //账户类型
        //bankAcctExtInfo.put("acctAttr","");
        //账号
        //bankAcctExtInfo.put("acctNum","");
        //银行预留手机
        //bankAcctExtInfo.put("bankReservePhone","");
        //银行代码
        //bankAcctExtInfo.put("openBankNo","");
        //开户行支行名称
        //bankAcctExtInfo.put("openBankBranchName","");
        //支付行号
        //bankAcctExtInfo.put("payBankNumber","");
        //开户行所在省
        //bankAcctExtInfo.put("openBankProvince","");
        //开户行所在市
        //bankAcctExtInfo.put("openBankCity","");
        //bankUserAddBindCardAppReq.setBankAcctExtInfo(bankAcctExtInfo);

        Map<String, Object> response = BasePayClient.request(bankUserAddBindCardAppReq);
        System.out.println(response);
    }
}