package com.allinpay.ystpay.sample.v1.trans;

import java.io.File;
import java.util.Map;

import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.config.BasePayConfig;
import com.allinpay.ystpay.sdk.core.config.MerConfig;
import com.allinpay.ystpay.sdk.core.request.BaseReq;

/***
 * @Description 功能描述：公共的参数封装DEMO
 */
public class BaseDemo
{
    /***
     * @Description: 初始化设置商户公共参数（全局只需设置一次）
     * @param merConfig
     * @throws Exception
     */
    public static void doInit(MerConfig merConfig) throws Exception
    {
        BasePayConfig.initWithMerConfig(merConfig);
    }

    /***
     * @Description: 执行API调用
     * @param request
     * @throws Exception Map<String,Object>
     */
    public static Map<String, Object> doExecute(BaseReq request) throws Exception
    {
        return BasePayClient.request(request, false);
    }

    /***
     * @Description: 执行API调用
     * @param request 请求参数
     * @param isPage 是否是页面版本
     * @throws Exception Map<String,Object>
     */
    public static Map<String, Object> doExecute(BaseReq request, boolean isPage) throws Exception
    {
        return BasePayClient.request(request, isPage);
    }

    /**
     * 执行API调用
     *
     * @param file 待上传文件
     * @return
     * @throws Exception
     */
    public static Map<String, Object> doExecute(File file) throws Exception
    {
        return BasePayClient.upload(file, null);
    }

    /**
     * 执行API调用
     *
     * @param file 待上传文件
     * @return
     * @throws Exception
     */
    public static Map<String, Object> doExecute(File file, String appId) throws Exception
    {
        return BasePayClient.upload(file, appId);
    }

    /**
     * 执行API调用
     *
     * @param req 下载请求
     * @return
     * @throws Exception
     */
    public static Map<String, Object> doDownload(BaseReq req) throws Exception
    {
        return BasePayClient.download(req, null);
    }
}
