package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BatchSignAcctSplitAgreementReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BatchSignAcctSplitAgreementDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建批量签订分账协议
        BatchSignAcctSplitAgreementReq batchSignAcctSplitAgreementReq = new BatchSignAcctSplitAgreementReq();
        //请求流水号
        batchSignAcctSplitAgreementReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        batchSignAcctSplitAgreementReq.setSignNum("WX202409260001");
        //签约会员名称
        batchSignAcctSplitAgreementReq.setMemberName("WX202409260001");
        //协议类型 3-收单分账服务协议
        batchSignAcctSplitAgreementReq.setAgreementType("3");
        //分账人列表文件
        batchSignAcctSplitAgreementReq.setAgreementFile("MjAyNDEwMTBmNXzlvKDkuInkupR8MXwxMAoKCg==");
        //跳转页面类型 1-H5页面 2-小程序页面
//        batchSignAcctSplitAgreementReq.setJumpPageType("1");
        //前台跳转地址
//        batchSignAcctSplitAgreementReq.setJumpUrl("");
        //签约结果通知地址
        batchSignAcctSplitAgreementReq.setNotifyUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");

        Map<String, Object> response = BasePayClient.request(batchSignAcctSplitAgreementReq);
        System.out.println(response);
    }
}
