package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.BusinessOrderManangeReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class BusinessOrderManangeDemo  extends BaseDemo{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建创建业务单
        BusinessOrderManangeReq businessOrderManangeReq = new BusinessOrderManangeReq();
        //服务单操作类型 1-创建业务单 2-业务单查询 3-关闭业务单 4-创建分期单 5-用户授权协议查询
        businessOrderManangeReq.setOpType("1");
        //请求流水号
        businessOrderManangeReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //收银宝商户号
        //createBusinessOrderReq.setVspCusid("");
        //服务id
        businessOrderManangeReq.setServiceId("00003004000000166634214238830274");
        //业务参数
        businessOrderManangeReq.setBizParam(createBusinessOrder());

        Map<String, Object> response = BasePayClient.request(businessOrderManangeReq);
        System.out.println(response);
    }

    //创建业务单
    public static JSONObject createBusinessOrder(){
        JSONObject bizParam = new JSONObject();
        //商户订单号
        bizParam.put("outOrderId","Iphone14 256G");
        //订单标题
        bizParam.put("title","Iphone14 256G");
        //追踪ID
        bizParam.put("sourceId","MjAfSVNfTlVMA==");
        //订单类型
        bizParam.put("merchantBizType","KX_SHOPPING");
        //商家小程序对应的订单详情页路径地址
        bizParam.put("path","/pages/index/index?orderId=1019060");
        //订单信息
        bizParam.put("orderDetail",getOrderDetail());
        //卖家支付宝用户ID
        bizParam.put("sellerId","2088401374030307");
        //买家ID
        bizParam.put("buyerId","2088102146225135");
        //买家支付宝用户唯一标识
        bizParam.put("buyerOpenId","074a1CcTG1LelxKe4xQC0zg");
        //买家支付宝登录账号
        bizParam.put("buyerLogonId","13212314527");
        //门店信息
        //bizParam.put("shopInfo",getShopInfoDetail());
         //芝麻信用信息
        //bizParam.put("creditInfo",getCreditInfo());
        //阶段付款计划
        //bizParam.put("stagePayPlans",getStagePayPlans());
         //买家联系人信息
        //bizParam.put("contactInfo",getContactInfo());
        //订单收货地址
        //bizParam.put("addressInfo",getAddressInfo());
        //订单优惠信息
        //bizParam.put("promoDetaiInfo",getPromoDetailInfo());
        //订单扩展字段
       // bizParam.put("extInfo",getExInfo());
        //物流信息
        //bizParam.put("deliveryDetail",getDeliveryDetail());
         //默认退货地址
        //bizParam.put("defaultReceivingAddress",getDefaultReceivingAddress());

        return bizParam;
    }

    //业务单查询
    public static JSONObject businessOrderQuery(){
        JSONObject bizParam = new JSONObject();
        //商户订单号
        bizParam.put("outOrderId","2324447384hu34h");
        //交易组件订单号
        bizParam.put("orderId","2015042321001004720200028594");
        //买家支付宝用户
        bizParam.put("userId","345556ghfh");
        //支付宝用户open_id
        bizParam.put("openId","45fr56ghfh");

        return bizParam;
    }

    //业务单关闭
    public static JSONObject businessOrderClose(){
        JSONObject bizParam = new JSONObject();
        //商户订单号
        bizParam.put("outOrderId","2324447384hu34h");
        //交易组件订单号
        bizParam.put("orderId","2015042321001004720200028594");
        //买家支付宝用户
        bizParam.put("userId","345556ghfh");
        //支付宝用户open_id
        bizParam.put("openId","45fr56ghfh");

        return bizParam;
    }

    //创建分期业务单
    public static JSONObject createSepBusinessOrder(){
        JSONObject bizParam = new JSONObject();
        //外部分期单号
        bizParam.put("outInstallmentOrderId","323435fr");
        //分期类型
        bizParam.put("type","RENT");
        //交易组件订单号
        bizParam.put("orderId","2015042321001004720200028594");
        //外部商户订单号
        bizParam.put("outOrderId","2324447384hu34h");
        //买家支付宝用户
        bizParam.put("userId","345556ghfh");
        //支付宝用户open_id
        //bizParam.put("openId","45fr56ghfh");
        //分期金额
        //bizParam.put("installmentPrice",new Long(100));
        //分期号类型
        //bizParam.put("installmentNoType","PERIOD");
        //本次分期号
        //bizParam.put("installmentNo","1");
        //分期是否完结
        //bizParam.put("isFinishPerformance","true");
        //分期单支付渠道
        //bizParam.put("payChannel","ALIPAY"));
        //分期阶段编码
        //bizParam.put("stageNo","1");
        //是否同步主动支付
        //bizParam.put("isSyncPay","true");

        return bizParam;
    }

    //用户授权协议查询
    public static JSONObject UserAuthAgreementQuery(){
        JSONObject bizParam = new JSONObject();
        //商户外部协议号
        bizParam.put("outAgreementNo","2324447384hu34h");
        //开通/授权协议号
        bizParam.put("creditAgreementId","2015042321001004720200028594");

        return bizParam;
    }

    //OrderDetail的明细字段
    public static JSONObject getOrderDetail(){

        JSONObject orderDetail = new JSONObject();
        //商品详细信息
        JSONObject itemInfos = new JSONObject();
        //商品名称
        itemInfos.put("goodsName","good1");
        //商品数量
        itemInfos.put("itemCnt","5");
        //商品单价
        itemInfos.put("salePrice","100.00");
        //商品的编号
        itemInfos.put("goodsId","1234567");
        //商户商品ID
        //itemInfos.put("ouItemId","123");
        //商户商品sku_id
        //itemInfos.put("outSkuId","34567576565656");
        //商品实际单价
        //itemInfos.put("saleRealPrice","");
        //商家商品优惠金额
        //itemInfos.put("itemDiscount","1.00");
        //商家商品素材ID
        //itemInfos.put("imageMaterialId","");
        //商品分期信息
        //itemInfos.put("itemInstallmentInfo","");
        //商品类型
        //itemInfos.put("goodsType","VIRTUAL");
        //租金信息
        //itemInfos.put("rentInfo","");
        //商品描述信息
        //itemInfos.put("body","");
        //价格日历
        //itemInfos.put("effectiveDates","");
        //票务信息
        //itemInfos.put("ticketInfo","");
        //活动信息
        //itemInfos.put("activityInfo","");
        orderDetail.put("itemInfos",itemInfos);

        //priceInfo的明细字段
        JSONObject priceInfo = new JSONObject();
        //订单金额
        priceInfo.put("orderPrice","88.88");
        //运费
        //priceInfo.put("freight","100");
        //商家优惠金额
        //priceInfo.put("discountedPrice","88.88");
        //商家储值金额
        //priceInfo.put("merchantValuePrice","100");
        orderDetail.put("priceInfo",priceInfo);

        //payInfo的明细字段
        JSONObject payInfo = new JSONObject();
        //支付渠道
        payInfo.put("paymentBizType","FREE");
        //支付方式
        payInfo.put("paymentMethod","COUNTER");

        orderDetail.put("payInfo",payInfo);


        return orderDetail;
    }

    //shopInfo的详细字段
    public static JSONObject getShopInfoDetail(){

        //商品详细信息
        JSONObject shopInfo = new JSONObject();
        //门店名称
        shopInfo.put("name","name");
        //门店地址
        shopInfo.put("address","address");
        //商家侧门店id
        shopInfo.put("merchantShopId","1000");
        //蚂蚁侧门店id
        shopInfo.put("alipayShopId","2018011900502000000005124744");

        return shopInfo;
    }

    //creditInfo的详细字段
    public static JSONObject getCreditInfo(){

        //芝麻信用信息
        JSONObject creditInfo = new JSONObject();
        //信用服务ID
        creditInfo.put("zmServiceId","2015042321001004720200028594");
        //商户外部协议号
        creditInfo.put("outAgreementNo","6823789339978248");

        return creditInfo;
    }

    //stagePayPlans的详细字段
    public static JSONObject getStagePayPlans(){

        //阶段付款计划
        JSONObject stagePayPlans = new JSONObject();
        //阶段编码
        stagePayPlans.put("stageNo","1");
        //计划信息列表
        JSONObject stagePayPlanInfos =new JSONObject();
        //计划付款编号
        stagePayPlanInfos.put("planPayNo","1");
        //计划付款金额
        stagePayPlanInfos.put("planPayPrice","100.00");
        //计划付款时间
        stagePayPlanInfos.put("planPayTime","2024-04-10 12:00:00");

        stagePayPlans.put("stagePayPlanInfos",stagePayPlanInfos);

        return stagePayPlans;
    }

    //contactInfo买家联系人信息的详细字段
    public static JSONObject getContactInfo(){

        //联系人信息
        JSONObject contactInfo = new JSONObject();
        //手机号
        contactInfo.put("phoneNumber","13212314567");
        //联系人姓名
        contactInfo.put("contactName","zhangsan");
        //联系人信息加密内容
        contactInfo.put("encryptionContent","");

        return contactInfo;
    }

    //addressInfo订单收货人地址的详细字段
    public static JSONObject getAddressInfo(){

        //订单收货地址
        JSONObject addressInfo = new JSONObject();
        //收货人
        addressInfo.put("receiverName","zhangsan");
        //收货地址
        addressInfo.put("detailedAddress","ChinaZheJiang");
        //联系方式
        addressInfo.put("telNumber","13212314567");
        //收货邮编地址
        addressInfo.put("receiverZip","310006");
        //标准城市域码
        addressInfo.put("receiverDivisionCode","310006");

        return addressInfo;
    }

    //promoDetailInfo订单优惠信息的详细字段
    public static JSONObject getPromoDetailInfo(){

        //订单优惠信息
        JSONObject promoDetailInfo = new JSONObject();
        //优惠活动咨询ID
        promoDetailInfo.put("activityConsultId","c2d081e6ba4e485db41cbd55244031cb");

        return promoDetailInfo;
    }

    //extInfo订单扩展字段的详细字段
    public static JSONObject getExInfo(){

        //订单扩展字段
        JSONObject exInfo = new JSONObject();
        //预约上门取件时间
        exInfo.put("doorTime","2024-12-16 15:00:00");
        //芝麻租赁授权签名
        //exInfo.put("orderStr","");
        //订单交易类型
        //exInfo.put("orderTradeType","ESCROW_TRADE");
        //交易号
        //exInfo.put("tradeNo","2023122801600000112348****190031");
        //订单附加返佣金额基数
        //exInfo.put("additionRebateBasePrice","100.00");
        //代扣协议签约场景
        //exInfo.put("deductSignScene","INDUSTRY|CARRENTAL");
        //企业的统一社会信用代码
        //exInfo.put("creditCode","");
        //企业支付宝账号
        //exInfo.put("alipayAccount","");

        return exInfo;
    }

    //deliveryDetail物流信息的详细字段
    public static JSONObject getDeliveryDetail(){

        //物流信息
        JSONObject deliveryDetail = new JSONObject();
        //物流类型
        deliveryDetail.put("deliveryType","EXPRESS");
        //配送时间
        deliveryDetail.put("deliveryTime","2023-06-01 23:23:22");

        return deliveryDetail;
    }

    //defaultReceivingAddress默认退货地址的详细字段
    public static JSONObject getDefaultReceivingAddress(){

        //默认退货地址
        JSONObject defaultReceivingAddress = new JSONObject();
        //收货人
        defaultReceivingAddress.put("receiverName","zhangsan");
        //收货地址
        defaultReceivingAddress.put("detailedAddress","ChinaZheJiang");
        //联系方式
        defaultReceivingAddress.put("telNumber","13212314567");
        //收货邮编地址
        defaultReceivingAddress.put("receiverZip","310006");
        //标准城市域码
        defaultReceivingAddress.put("receiverDivisionCode","310006");

        return defaultReceivingAddress;
    }
}