package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.CreateParkingEntryReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class CreateParkingEntryDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建创建停车入场
        CreateParkingEntryReq createParkingEntryReq = new CreateParkingEntryReq();
        //商户请求流水号
        createParkingEntryReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //微信应用ID
        createParkingEntryReq.setWxAppid("1223de33ddqqde2j");
        //微信商户号
        createParkingEntryReq.setWxMchid("1223de33ddqqde2j");
        //商户入场id
        createParkingEntryReq.setOutParkingNo("1223de33ddqqde2j");
        //车牌号
        createParkingEntryReq.setPlateNumber("苏A589A0");
        //车牌颜色
        createParkingEntryReq.setPlateColor("BLACK");
        //入场时间
        createParkingEntryReq.setStartTime("2025-05-20T13:29:35+08:00");
        //停车场名称
        createParkingEntryReq.setParkingName("奥体中心停车场");
        //免费时长
        createParkingEntryReq.setFreeDuration(new Long(600));


        Map<String, Object> response = BasePayClient.request(createParkingEntryReq);
        System.out.println(response);
    }
}

