package com.allinpay.ystpay.sample.v1.trans;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.core.request.DownloadFileReq;

public class DownloadFileDemo extends BaseDemo
{
    public static void main(String[] args) throws Exception
    {
        // 初始化
        doInit(MerConfigDemo.getMerchantConfig());
        // 组装文件下载请求
        DownloadFileReq req = new DownloadFileReq();
        // 对账文件类型
        req.setFileType("1");
        // 对账文件日期
        req.setFileDate("20250526");
        // 文件维度
        req.setFileDimension("orderDaily");

        // 执行
        Map<String, Object> response = doDownload(req);
        // 保存文件
        if (!response.containsKey("fileByteArray"))
        {
            System.out.println(response);
            return;
        }
        Files.write(Paths.get("/Users/gejunqing/Downloads/" + response.get("fileName")),
                (byte[]) response.get("fileByteArray"));
    }
}
