package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.EnterpriseMemberAccountRealNameReq;
import com.allinpay.ystpay.sdk.core.utils.SM4Utils;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class EnterpriseMemberAccountRealNameDemo extends BaseDemo{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建企业会员实名开户
        EnterpriseMemberAccountRealNameReq enterpriseMemberAccountRealNameReq = new EnterpriseMemberAccountRealNameReq();
        //商户请求流水号
        enterpriseMemberAccountRealNameReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        enterpriseMemberAccountRealNameReq.setSignNum("JACK20240520202");
        //会员角色
        enterpriseMemberAccountRealNameReq.setMemberRole("");
        //企业会员审核结果通知地址
        enterpriseMemberAccountRealNameReq.setNotifyUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //企业基本信息
        JSONObject enterpriseBaseInfo = new JSONObject();
        //银行账户信息
        JSONObject bankAcctDetail = new JSONObject();

        //企业基本信息JSON(enterpriseBaseInfo)
        //企业名称
        enterpriseBaseInfo.put("enterpriseName", "测试公司");
        //企业性质：1-企业 2-个体工商户 3-事业单位
//        enterpriseBaseInfo.put("enterpriseNature", "");
        //省市地区码
        enterpriseBaseInfo.put("addressCode", "320102");
        //企业注册地址
        enterpriseBaseInfo.put("enterpriseAdress", "南京市安德门大街57号");
        //统一社会信用
        enterpriseBaseInfo.put("unifiedSocialCredit", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(),"4567891209"));
        //营业证件有效期  格式：YYYY-MM_DD
//        enterpriseBaseInfo.put("busLicenseValidate", "");
        //法人姓名
        enterpriseBaseInfo.put("legalPersonName", "张三");
        //法人证件类型
        enterpriseBaseInfo.put("legalPersonCerType", "1");
        //法人证件号码 SM4加密
        enterpriseBaseInfo.put("legalPersonCerNum", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "320102199203031010"));
        //法人证件有效开始日期 格式：YYYY-MM_DD
//        enterpriseBaseInfo.put("idValidateStart", "");
        //法人证件有效截止日期 格式：YYYY-MM_DD
//        enterpriseBaseInfo.put("idValidateEnd", "");
        //法人手机号码
        enterpriseBaseInfo.put("legalPersonPhone", "15910144031");
        //法人身份证（肖像面）
//        enterpriseBaseInfo.put("legpCerFrontFileId", "");
        //法人身份证（国徽面）
//        enterpriseBaseInfo.put("legpCerBackFileId", "");
        //统一信用证
//        enterpriseBaseInfo.put("unifiedSocialCreditFileId", "");
        enterpriseMemberAccountRealNameReq.setEnterpriseBaseInfo(enterpriseBaseInfo);

        //银行账户信息JSON(bankAcctDetail)
        //账户类型
//        bankAcctDetail.put("acctAttr","");
        //账号 SM4加密
        bankAcctDetail.put("acctNum", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "47582648456"));
        //银行预留手机
//        bankAcctDetail.put("bankReservePhone","");
        //银行代码
//        bankAcctDetail.put("openBankNo","");
        //开户行支行名称  账户类型=1-对公，则必填
//        bankAcctDetail.put("openBankBranchName","");
        //支付行号，12位数字  账户类型=1-对公，则必填
//        bankAcctDetail.put("payBankNumber","");
        //开户行所在省
        bankAcctDetail.put("openBankProvince","江苏省");
        //开户行所在市
        bankAcctDetail.put("openBankCity","南京市");
        enterpriseMemberAccountRealNameReq.setBankAcctDetail(bankAcctDetail);

        //企业详情信息
        JSONObject enterpriseDetail = new JSONObject();
        //企业规模
        enterpriseDetail.put("enterpriseScale","");
        //企业类型
        enterpriseDetail.put("enterpriseType","");
        //企业经济性质
        enterpriseDetail.put("economicNature","");
        //国籍
        enterpriseDetail.put("country","");
        //企业注册资本
        enterpriseDetail.put("regCapital","");
        //行业
        enterpriseDetail.put("occupation","");
        //公司经营开始时间
        enterpriseDetail.put("businessBeginDate","");
        //公司经营结束日期
        enterpriseDetail.put("businessEndDate","");
        //企业联系人手机号
        enterpriseDetail.put("contactMobile","");
        //经营地址省市区
        enterpriseDetail.put("linkAddresscode","");
        //经营详细地址/企业联系地址
        enterpriseDetail.put("enterpriseAddress","");
        //经营范围
        enterpriseDetail.put("businessScope","");
        //开户许可证核准号或基本存款账户编号
        enterpriseDetail.put("openLicenseCode","");
        //开户许可证文件
        enterpriseDetail.put("openLicenseToken","");
        //控股股东/实际控制人
        JSONObject shareholderInfo = new JSONObject();
        //控股股东/实际控制人名称
        shareholderInfo.put("shareholderName","");
        //控股股东/实际控制人证件类型
        shareholderInfo.put("shareholderCertType","");
        //控股股东/实际控制人证件号
        shareholderInfo.put("shareholderCertNo","");
        //控股股东/实际控制人证件开始日期
        shareholderInfo.put("shareholderCertBeginDate","");
        //控股股东/实际控制人证件截止日期
        shareholderInfo.put("shareholderCertEndDate","");
        //股东或实际控制人电话
        shareholderInfo.put("shareholderPhone","");
        enterpriseDetail.put("shareholderInfo",shareholderInfo);
        //受益所有人信息
        JSONObject beneficiaryInfo = new JSONObject();
        //受益所有人名称
        beneficiaryInfo.put("beneficiaryName","");
        //受益所有人地址
        beneficiaryInfo.put("beneficiaryAddress","");
        //受益所有人电话
        beneficiaryInfo.put("beneficiaryPhone","");
        //受益所有人证件类型
        beneficiaryInfo.put("beneficiaryIdType","");
        //受益所有人证件号码
        beneficiaryInfo.put("beneficiaryIdNo","");
        //受益所有人证件开始日期
        beneficiaryInfo.put("beneficiaryIdEffDate","");
        //受益所有人证件到期日期
        beneficiaryInfo.put("beneficiaryIdOffDate","");
        enterpriseDetail.put("beneficiaryInfo",beneficiaryInfo);

        enterpriseMemberAccountRealNameReq.setEnterpriseDetail(enterpriseDetail);
        //银行开户请求信息
        JSONObject bankAcctReqInfo = new JSONObject();
        //开户银行编码
        bankAcctReqInfo.put("openBankNo","");
        //银行用户角色，透传银行
        bankAcctReqInfo.put("acctRole","");
        //个人用户注册手机号
        bankAcctReqInfo.put("registerPhone","");
        //协议编号
        bankAcctReqInfo.put("agreementNo","");
        //是否银行绑卡
        bankAcctReqInfo.put("bindCardFlag","");
        //个人用户授权协议版本号
        bankAcctReqInfo.put("authProtocolVerNum","");
        //个人用户授权协议流水号
        bankAcctReqInfo.put("authProtocolOrderNo","");

        enterpriseMemberAccountRealNameReq.setBankAcctReqInfo(bankAcctReqInfo);


        Map<String, Object> response = BasePayClient.request(enterpriseMemberAccountRealNameReq);
        System.out.println(response);
    }
}
