package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.EnterpriseMemberBindCorporateAccountReq;
import com.allinpay.ystpay.sdk.core.utils.SM4Utils;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class EnterpriseMemberBindCorporateAccountDemo extends BaseDemo{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建企业会员新增绑定对公户
        EnterpriseMemberBindCorporateAccountReq enterpriseMemberBindCorporateAccountReq = new EnterpriseMemberBindCorporateAccountReq();
        //商户请求流水号
        enterpriseMemberBindCorporateAccountReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        enterpriseMemberBindCorporateAccountReq.setSignNum("gejunqing");
        //银行账户信息
        JSONObject bankAcctDetail = new JSONObject();
        //银行账户信息JSON(bankAcctDetail)
        //账户类型
//        bankAcctDetail.put("acctAttr","");
        //账号 SM4加密
        bankAcctDetail.put("acctNum", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "47582648456"));
        //银行代码
//        bankAcctDetail.put("openBankNo","");
        //开户行支行名称  账户类型=1-对公，则必填
//        bankAcctDetail.put("openBankBranchName","");
        //支付行号，12位数字  账户类型=1-对公，则必填
//        bankAcctDetail.put("payBankNumber","");
        //开户行所在省
        bankAcctDetail.put("openBankProvince","江苏省");
        //开户行所在市
        bankAcctDetail.put("openBankCity","南京市");
        enterpriseMemberBindCorporateAccountReq.setBankAcctDetail(bankAcctDetail);

        Map<String, Object> response = BasePayClient.request(enterpriseMemberBindCorporateAccountReq);
        System.out.println(response);
    }
}

