package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.EnterpriseMemberInfoModifyReq;
import com.allinpay.ystpay.sdk.core.utils.SM4Utils;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class EnterpriseMemberInfoModifyDemo extends BaseDemo{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建企业会员信息修改
        EnterpriseMemberInfoModifyReq enterpriseMemberInfoModifyReq = new EnterpriseMemberInfoModifyReq();
        //商户请求流水号
        enterpriseMemberInfoModifyReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        enterpriseMemberInfoModifyReq.setSignNum("JACK20240520202");
        //企业会员信息修改结果通知地址
        enterpriseMemberInfoModifyReq.setNotifyUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //企业基本信息
        JSONObject enterpriseBaseInfo = new JSONObject();

        //企业基本信息JSON(enterpriseBaseInfo)
        //企业名称
        enterpriseBaseInfo.put("enterpriseName", "测试公司");
        //地区码（注册地
        enterpriseBaseInfo.put("addressCode", "320102");
        //企业注册地址
        enterpriseBaseInfo.put("enterpriseAdress", "南京市安德门大街57号");
        //营业证件有效期  格式：YYYY-MM_DD
//        enterpriseBaseInfo.put("busLicenseValidate", "");
        //法人姓名
        enterpriseBaseInfo.put("legalPersonName", "张三");
        //法人证件类型
        enterpriseBaseInfo.put("legalPersonCerType", "1");
        //法人证件号码 SM4加密
        enterpriseBaseInfo.put("legalPersonCerNum", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "320102199203031010"));
        //法人证件有效开始日期 格式：YYYY-MM_DD
//        enterpriseBaseInfo.put("idValidateStart", "");
        //法人证件有效截止日期 格式：YYYY-MM_DD
//        enterpriseBaseInfo.put("idValidateEnd", "");
        //法人手机号码
        enterpriseBaseInfo.put("legalPersonPhone", "15910144031");
        //对公户名
        enterpriseBaseInfo.put("publicAcctName", "");
        //法人身份证（肖像面）
        enterpriseBaseInfo.put("legpCerFrontFileId", "");
        //法人身份证（国徽面）
        enterpriseBaseInfo.put("legpCerBackFileId", "1");
        //统一信用证
        enterpriseBaseInfo.put("unifiedSocialCreditFileId", "");

        enterpriseMemberInfoModifyReq.setEnterpriseBaseInfo(enterpriseBaseInfo);

        Map<String, Object> response = BasePayClient.request(enterpriseMemberInfoModifyReq);
        System.out.println(response);
    }
}

