package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.EnterpriseMemberPaymentAccountOpenReq;
import com.allinpay.ystpay.sdk.core.utils.SM4Utils;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class EnterpriseMemberPaymentAccountOpenDemo extends BaseDemo{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建企业会员支付账户开户
        EnterpriseMemberPaymentAccountOpenReq enterpriseMemberPaymentAccountOpenReq = new EnterpriseMemberPaymentAccountOpenReq();
        //商户请求流水号
        enterpriseMemberPaymentAccountOpenReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        enterpriseMemberPaymentAccountOpenReq.setSignNum("gejunqing");
        //会员角色
        enterpriseMemberPaymentAccountOpenReq.setMemberRole("二级商户");
        //企业性质：1-企业 2-个体工商户 3-事业单位 不填，则默认“企业” 注：企业名称含“公司”，不支持上送“个体工商户”
        enterpriseMemberPaymentAccountOpenReq.setEnterpriseNature("1");
        //企业会员审核结果通知地址
        enterpriseMemberPaymentAccountOpenReq.setNotifyUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //企业基本信息
        JSONObject enterpriseBaseInfo = new JSONObject();
        //受益人信息
        JSONObject legaAndBeneficiaryInfo = new JSONObject();
        //银行账户信息
        JSONObject bankAcctDetail = new JSONObject();
        //开户附件材料
        JSONObject attachments = new JSONObject();

        //企业基本信息JSON（enterpriseBaseInfo）
        //企业名称
//      enterpriseBaseInfo.put("enterpriseName", "测试公司");
        //省市地区码
//        enterpriseBaseInfo.put("addressCode", "320102");
        //企业注册地址
//        enterpriseBaseInfo.put("enterpriseAdress", "南京市安德门大街57号");
        //统一社会信用
//        enterpriseBaseInfo.put("unifiedSocialCredit", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(),"4567891209"));
        //营业证件有效期  格式：YYYY-MM-DD
        enterpriseBaseInfo.put("busLicenseValidate", "2025-05-01");
        //法人姓名
//        enterpriseBaseInfo.put("legalPersonName", "张三");
        //法人证件类型
//        enterpriseBaseInfo.put("legalPersonCerType", "1");
        //法人证件号码 SM4加密
//        enterpriseBaseInfo.put("legalPersonCerNum", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "320102199203031010"));
        //法人证件有效开始日期 格式：YYYY-MM_DD
        enterpriseBaseInfo.put("idValidateStart", "");
        //法人证件有效截止日期 格式：YYYY-MM_DD
        enterpriseBaseInfo.put("idValidateEnd", "");
        //法人手机号码
//        enterpriseBaseInfo.put("legalPersonPhone", "15910144031");
        //经营内容
        enterpriseBaseInfo.put("busiScope","");
        enterpriseMemberPaymentAccountOpenReq.setEnterpriseBaseInfo(enterpriseBaseInfo);

        //受益人信息JSON（legaAndBeneficiaryInfo）
        //法人国籍
        legaAndBeneficiaryInfo.put("legalCountry","中华人民共和国");
        //法人性别
        legaAndBeneficiaryInfo.put("legalSex","1");
        //法人职业
        legaAndBeneficiaryInfo.put("legalCareer","1");
        //法人住址
        legaAndBeneficiaryInfo.put("legalAddress","");
        //商户类型
        legaAndBeneficiaryInfo.put("merchantType","");
        //受益所有人判定标准
//        legaAndBeneficiaryInfo.put("beneficiaryJudgmentCriteria","");
        //受益所有人证明材料类型
//        legaAndBeneficiaryInfo.put("beneficiaryJudgmentFile","");
        //法人是否受益人
        legaAndBeneficiaryInfo.put("legalIsBeneficiary","0");
        //法人是否为股东控制人
        legaAndBeneficiaryInfo.put("legalIsShareholder","0");
        //受益人证件类型
        legaAndBeneficiaryInfo.put("beneficiaryCerType","");
        //受益人姓名
        legaAndBeneficiaryInfo.put("beneficiaryName","");
        //受益人证件号码
        legaAndBeneficiaryInfo.put("beneficiaryCerNum","");
        //受益人证件证件有效期
        legaAndBeneficiaryInfo.put("beneficiaryCerValidate","");
        //是否为高管
        legaAndBeneficiaryInfo.put("isSeniorManagement","");
        //受益人住址
        legaAndBeneficiaryInfo.put("beneficiaryAddress","");
        //控股股东姓名
        legaAndBeneficiaryInfo.put("shareholderName","");
        //控股股东证件号码 SM4加密
        legaAndBeneficiaryInfo.put("shareholderCerNum",SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(),"324653198708080909"));
        //控股股东证件有效期
        legaAndBeneficiaryInfo.put("shareholderCerValidate","0");
        enterpriseMemberPaymentAccountOpenReq.setLegaAndBeneficiaryInfo(legaAndBeneficiaryInfo);

        //银行账户信息JSON（bankAcctDetail）
        //账户类型
//        bankAcctDetail.put("acctAttr","");
        //账号 SM4加密
        bankAcctDetail.put("acctNum", SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "47582648456"));
        //银行预留手机
//        bankAcctDetail.put("bankReservePhone","");
        //银行代码
//        bankAcctDetail.put("openBankNo","");
        //开户行支行名称  账户类型=1-对公，则必填
//        bankAcctDetail.put("openBankBranchName","");
        //支付行号，12位数字  账户类型=1-对公，则必填
//        bankAcctDetail.put("payBankNumber","");
        //开户行所在省
        bankAcctDetail.put("openBankProvince","江苏省");
        //开户行所在市
        bankAcctDetail.put("openBankCity","南京市");
        enterpriseMemberPaymentAccountOpenReq.setBankAcctDetail(bankAcctDetail);

        //开户附件材料JSON（attachments）
        //统一信用证照片
        attachments.put("unifiedSocialCreditPhoto","");
        //法人证件（国徽面）
        attachments.put("legalNationalEmblemPhoto","");
        //法人证件（肖像面）
        attachments.put("legalFacePhoto","");
        //结算账户照
        attachments.put("settleAcctPhoto","");
        //经营门头照片
        attachments.put("businessDoorHeadPhoto","");
        //经营内景照片
        attachments.put("businessInteriorPhoto","");
        //客户经理与门头照
        attachments.put("accountManagerWithDoorPhoto","");
        //客户经理手持身份证照片
        attachments.put("accountManagerHoldingIdCardPhoto","");
        //受益所有人证明材料
        attachments.put("beneficiaryFile","");
        enterpriseMemberPaymentAccountOpenReq.setAttachments(attachments);

        Map<String, Object> response = BasePayClient.request(enterpriseMemberPaymentAccountOpenReq);
        System.out.println(response);
    }
}

