package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.GuaranteeConsumptionReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class GuaranteeConsumptionDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建担保消费
        GuaranteeConsumptionReq guaranteeConsumptionReq = new GuaranteeConsumptionReq();
        //商户订单号
        guaranteeConsumptionReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号-付款人
        guaranteeConsumptionReq.setSignNum("JACK20240520202");
        //收款人列表
        JSONArray receiverList =new JSONArray();
        JSONObject rl = new JSONObject();
        //商户会员编号
        rl.put("signNum","gejunqing");
        //收款金额
        rl.put("amount",new Long(100));
        receiverList.add(rl);
        guaranteeConsumptionReq.setReceiverList(receiverList);
        //商品类型
        guaranteeConsumptionReq.setGoodsType("");
        //商户商品编号
        guaranteeConsumptionReq.setBizGoodsNo("");
        //订单金额
        guaranteeConsumptionReq.setOrderAmount(new Long(100));
        //支付金额
        guaranteeConsumptionReq.setPayAmount(new Long(100));
        //营销金额
        guaranteeConsumptionReq.setPromotionAmount(new Long(0));
        //前台通知地址
        guaranteeConsumptionReq.setReqsUrl("");
        //后台通知地址
        guaranteeConsumptionReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        //订单过期时间 格式：yyyy-MM-dd HH:mm:ss
        guaranteeConsumptionReq.setOrderValidTime("2025-05-31 00:00:00");
        //支付模式
        JSONObject parParams = new JSONObject();
        parParams.put("bankCardNo", "");
        parParams.put("agreementNo", "AIP621924021908F149B6F");
        parParams.put("validate", "");
        parParams.put("cvv2", "");
        parParams.put("remark", "");

        PayMode paymode = new PayMode("QUICKPAY_SFT",parParams);
        guaranteeConsumptionReq.setPayMode(paymode);
        //商品名称
        guaranteeConsumptionReq.setGoodsName("测试");
        //摘要
        guaranteeConsumptionReq.setSummary("");
        //扩展参数
        guaranteeConsumptionReq.setExtendParams("");
        //交易所在省市
        guaranteeConsumptionReq.setTxDistrictCode("11");
        //商品描述
//        guaranteeConsumptionReq.setGoodsDesc("");

        Map<String, Object> response = BasePayClient.request(guaranteeConsumptionReq);
        System.out.println(response);
    }
}