package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.IndustryOrderReq;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndustryOrderDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建行业收银台下单
        IndustryOrderReq industryOrderReq = new IndustryOrderReq();
        //行业收银台商户订单号
        industryOrderReq.setReqTraceNumCashier(SequenceTools.getReqSeqId32());
        //订单金额
        industryOrderReq.setOrderAmount(new Long(100));
        //营销金额
        industryOrderReq.setPromotionAmount(new Long(10));
        //平台抽佣金额
        industryOrderReq.setCouponAmount(new Long(10));
        //收款人
        industryOrderReq.setReceiverSignNum("");
        //行业收银参数JSON
        JSONObject cashierParam = new JSONObject();
        //收款模板编号
        cashierParam.put("cashierTemplateID","gejunqing");
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> map1 = new HashMap<>();
        map1.put("goodsNo","");
        map1.put("goodsTitle","");
        map1.put("goodsPrice","");
        map1.put("goodsNum","");
        list.add(map1);
        //商品信息
        cashierParam.put("goodsParam",list);
        industryOrderReq.setCashierParam(cashierParam);
        //支付模式
        JSONObject parParams = new JSONObject();
        parParams.put("bankCardNo", "");
        parParams.put("agreementNo", "AIP621924021908F149B6F");
        parParams.put("validate", "");
        parParams.put("cvv2", "");
        parParams.put("remark", "");

        PayMode paymode = new PayMode("QUICKPAY_SFT",parParams);
        industryOrderReq.setPayMode(paymode);
        //订单过期时间
        industryOrderReq.setOrderValidTime("");
        //前台通知地址
        industryOrderReq.setReqsUrl("");
        //后台通知地址
        industryOrderReq.setRespUrl("http://www.baidu.com");
        //扩展参数
        industryOrderReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(industryOrderReq);
        System.out.println(response);
    }
}