package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.IndustryRefundAppReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;
import java.util.Map;

public class IndustryRefundAppDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建行业收银台退款申请
        IndustryRefundAppReq industryRefundAppReq = new IndustryRefundAppReq();
        //行业收银台商户订单号-退款订单号
        industryRefundAppReq.setReqTraceNumCashier(SequenceTools.getReqSeqId32());
        //原收银台通联订单号
        industryRefundAppReq.setOrgRespTraceNumCashier("21751798293115834370");
        //是否全额原路退回
        industryRefundAppReq.setIsRefundAll("");
        //退款总金额
        industryRefundAppReq.setOrderAmount(new Long(100));
        //营销退款金额
        industryRefundAppReq.setPromotionAmount(new Long(10));
        //退款详情
        JSONArray refundDetail = new JSONArray();
        JSONObject sd = new JSONObject();
        //退款金额
        sd.put("orderAmount", new Long(100));
        //渠道退款金额
        sd.put("cnlRefundAmount", new Long(10));
        //平台抽佣退款金额
        sd.put("couponAmount", new Long(10));
        //分账退款列表
        JSONArray sepDetail = new JSONArray();
        JSONObject sp = new JSONObject();
        //分账方商户会员编号
        sp.put("signNum", "");
        //分账方退款金额
        sp.put("amount", new Long(10));
        //备注
        sp.put("remark", "");
        sepDetail.add(sp);
        sd.put("sepDetail", sepDetail);
        sepDetail.add(sd);
        industryRefundAppReq.setRefundDetail(refundDetail);
        //是否需要调拨资金
        industryRefundAppReq.setIsFundAllocation("");
        //是否允许收款人垫资
        industryRefundAppReq.setIsAdvancePay("");
        //后台通知地址
        industryRefundAppReq.setRespUrl("");
        //优惠信息
        //JSONObject chnlDiscAmt = new JSONObject();
        //摘要
        industryRefundAppReq.setSummary("");
        //扩展信息
        industryRefundAppReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(industryRefundAppReq);
        System.out.println(response);
    }
}