package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.MemberRealNameConfirmReq;
import com.allinpay.ystpay.sdk.core.utils.SM4Utils;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class MemberRealNameConfirmDemo  extends BaseDemo{
    public static void main(String[] args) throws Exception
    {

        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建个个人会员实名及绑卡（确认）请求
        MemberRealNameConfirmReq memberRealNameConfirmReq = new MemberRealNameConfirmReq();
        //请求流水号
        memberRealNameConfirmReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //商户会员编号
        memberRealNameConfirmReq.setSignNum("JACK20240520202");
        //申请响应业务关联流水号
        memberRealNameConfirmReq.setApplyRespTraceNum("20240618180507101000117142");
        //银行预留手机号
        memberRealNameConfirmReq.setPhone("18833665963");
        //有效期， SM4加密
        memberRealNameConfirmReq.setValidDate(SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "0524"));
        //CVV2， SM4加密
        memberRealNameConfirmReq.setCvv2(SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "068"));
        //短信验证码
        memberRealNameConfirmReq.setVerifyCode("123123");
        //用户协议号
        memberRealNameConfirmReq.setUserAgreeNo("123456");

        Map<String, Object> response = BasePayClient.request(memberRealNameConfirmReq);
        System.out.println(response);
    } }
