package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.MemberRealNameReq;
import com.allinpay.ystpay.sdk.core.utils.SM4Utils;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class MemberRealNameDemo extends BaseDemo{
        public static void main(String[] args) throws Exception
        {

            // 1. 数据初始化
            doInit(MerConfigDemo.getMerchantConfig());
            //构建个人会员实名及绑卡请求
            MemberRealNameReq memberRealNameReq = new MemberRealNameReq();
            //请求流水号
            memberRealNameReq.setReqTraceNum(SequenceTools.getReqSeqId32());
            //商户会员编号
            memberRealNameReq.setSignNum("gejunqing");
            //会员角色
            memberRealNameReq.setMemberRole("二级商户");
            //姓名
            memberRealNameReq.setName("张三");
            //证件类型
            memberRealNameReq.setCerType("1");
            //证件号码
            memberRealNameReq.setCerNum(SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "320103199901011100"));
            //银行卡号
            memberRealNameReq.setAcctNum(SM4Utils.encryptEcb(MerConfigDemo.getMerchantConfig().getEncryptKey(), "6230201988088913"));
            //银行预留手机
            memberRealNameReq.setPhone("15951716171");
            //绑卡方式
            memberRealNameReq.setBindType("8");
            //有效期，格式为月年;如0321
            memberRealNameReq.setValidDate("0524");
            //CVV2，3位数字
            memberRealNameReq.setCvv2("068");
            //联行号（支付行号）
            memberRealNameReq.setPayBankNumber("");
            //个人详细信息
            JSONObject personalDetail = new JSONObject();
            //手机号码
            personalDetail.put("phone","");
            //住所/工作地址
            personalDetail.put("address","");
            //地区码（省市区/县）
            personalDetail.put("areaCode","");
            //国籍、地区编码
            personalDetail.put("country","");
            //职业
            personalDetail.put("profession","");
            //证件有效开始日期
            personalDetail.put("certBeginDate","");
            //证件有效截止日期
            personalDetail.put("certEndDate","");
            //个人身份证（肖像面）token
            personalDetail.put("certFrontToken","");
            //个人身份证（国徽面）token
            personalDetail.put("certBackToken","");
            memberRealNameReq.setPersonalDetail(personalDetail);

            //银行开户请求信息
            JSONObject bankAcctReqInfo = new JSONObject();
            //开户银行编码
            bankAcctReqInfo.put("openBankNo","");
            //银行用户角色，透传银行
            bankAcctReqInfo.put("acctRole","");
            //个人用户注册手机号
            bankAcctReqInfo.put("registerPhone","");
            //协议编号
            bankAcctReqInfo.put("agreementNo","");
            //是否银行绑卡
            bankAcctReqInfo.put("bindCardFlag","");
            //个人用户授权协议版本号
            bankAcctReqInfo.put("authProtocolVerNum","");
            //个人用户授权协议流水号
            bankAcctReqInfo.put("authProtocolOrderNo","");

            memberRealNameReq.setBankAcctReqInfo(bankAcctReqInfo);

            //银行卡签约商户号
            //memberRealNameReq.setBankSignCusid("");
            Map<String, Object> response = BasePayClient.request(memberRealNameReq);
            System.out.println(response);
        }
    }

