package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.MerchantInfoManagementReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;


import java.util.Map;

public class MerchantInfoManagementDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建行业版商户信息管理
        MerchantInfoManagementReq merchantInfoManagementReq = new MerchantInfoManagementReq();
        //请求流水号
        merchantInfoManagementReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //操作类型
        merchantInfoManagementReq.setOpType("add");
        //商户列表 当 operType=add时必填
        JSONArray merList = new JSONArray();
        JSONObject ml = new JSONObject();
        //统一客户号
        ml.put("cusId", "2025081302");
        //商户类型：1：单商户 2：集团商户 3：代理商
        ml.put("merType", "1");
        merList.add(ml);
        merchantInfoManagementReq.setMerList(merList);

        Map<String, Object> response = BasePayClient.request(merchantInfoManagementReq);
        System.out.println(response);
    }
}
