package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.PlatformAdvanceFundRepaymentReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class PlatformAdvanceFundRepaymentDemo extends BaseDemo
{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        // 构建平台垫资还款
        PlatformAdvanceFundRepaymentReq platformAdvanceFundRepaymentReq = new PlatformAdvanceFundRepaymentReq();
        // 商户订单号
        platformAdvanceFundRepaymentReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        // 原垫资发放通联订单号
        platformAdvanceFundRepaymentReq.setOrgRespTraceNum("20241118103022208501393885");
        // 垫资发放金额
        platformAdvanceFundRepaymentReq.setOrderAmount(new Long(100));
        // 后台通知地址
        platformAdvanceFundRepaymentReq.setRespUrl("https://ibstest.allinpay.com/ystNotifyReceiver/testNotify");
        // 备注
        platformAdvanceFundRepaymentReq.setRemark("");
        // 扩展参数
        platformAdvanceFundRepaymentReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(platformAdvanceFundRepaymentReq);
        System.out.println(response);
    }
}