package com.allinpay.ystpay.sample.v1.trans;

import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.PlatformCollectionPaymentReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.Map;

public class PlatformCollectionPaymentDemo extends BaseDemo
{
    public static void main(String[] args) throws Exception
    {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        // 构建平台收付款
        PlatformCollectionPaymentReq platformCollectionPaymentReq = new PlatformCollectionPaymentReq();
        // 商户业务订单号
        platformCollectionPaymentReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        // 商户业务子订单号
        platformCollectionPaymentReq.setReqSubTraceNum("");
        // 操作类型
        platformCollectionPaymentReq.setOperateType("01");
        // 交易类型
        platformCollectionPaymentReq.setDealType("00");
        // 收付款会员编号
        platformCollectionPaymentReq.setSignNum("#yunBizUserId_B2C#");
        // 收付款银行子账号
        platformCollectionPaymentReq.setSubAcctNo("12324232332322");
        // 收付款银行子账号
        platformCollectionPaymentReq.setName("测试");
        // 交易金额
        platformCollectionPaymentReq.setTradeAmount(new Long(100));
        // 资金类型/商品信息
        platformCollectionPaymentReq.setFundType("01");
        // 备注
        platformCollectionPaymentReq.setRemark("");

        Map<String, Object> response = BasePayClient.request(platformCollectionPaymentReq);
        System.out.println(response);
    }
}