package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.PayMode;
import com.allinpay.ystpay.sdk.core.request.RefundApplicationReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class RefundApplicationDemo extends BaseDemo {
    public static void main(String[] args) throws Exception {
        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        //构建退款申请
        RefundApplicationReq refundApplicationReq = new RefundApplicationReq();
        //商户订单号
        refundApplicationReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        //原通联订单号
        refundApplicationReq.setOrgRespTraceNum("20250529090942209601569882");
        //退款总金额
        refundApplicationReq.setOrderAmount(new Long(100));
        //营销退款金额
        refundApplicationReq.setPromotionAmount(new Long(100));
        //订单退款列表
        JSONArray refundDetail =new JSONArray();
        JSONObject rd = new JSONObject();
        //商户会员编号
        rd.put("signNum","gejunqing");
        //退款金额
        rd.put("orderAmount",new Long(100));
        //账户类型
        rd.put("acctType","1");
        //平台抽佣退款金额
        rd.put("couponAmount",new Long(100));
        //分账退款列表
        JSONArray sepDetail = new JSONArray();
        JSONObject sd = new JSONObject();
        //商户会员编号
        sd.put("signNum", "gejunqing");
        //分账金额
        sd.put("amount", new Long(100));
        //备注
        sd.put("remark", "");
        sepDetail.add(sd);
        rd.put("sepDetail",sepDetail);
        refundDetail.add(rd);
        refundApplicationReq.setRefundDetail(refundDetail);
        //订单退款详情
        //JSONObject sepRefundInfo = new JSONObject();
        //refundApplicationReq.setSepRefundInfo(sepRefundInfo);
        //储值卡核销退款列表
        JSONArray svcRefundDetail =new JSONArray();
        JSONObject srd = new JSONObject();
        //商户会员编号
        srd.put("signNum","gejunqing");
        //储值卡核销退款金额
        srd.put("orderAmount",new Long(100));
        //平台抽佣退款金额
        srd.put("couponAmount",new Long(100));
        //分账退款列表
        srd.put("sepDetail",sepDetail);
        svcRefundDetail.add(srd);
        refundApplicationReq.setSvcRefundDetail(svcRefundDetail);

        //是否需要调拨资金 0：否 1：是 注：默认“0：否”
        refundApplicationReq.setIsFundAllocation("0");
        //是否允许收款人垫资 0：否 1：是 注：默认“0：否”
        refundApplicationReq.setIsAdvancePay("0");
        //后台通知地址
        refundApplicationReq.setRespUrl("http://www.baidu.com");
        //优惠信息
        //JSONObject chnlDiscAmt = new JSONObject();
        //refundApplicationReq.setChnlDiscAmt(chnlDiscAmt);
        //备注
        refundApplicationReq.setRemark("");
        //摘要
        refundApplicationReq.setSummary("");
        //扩展信息
        refundApplicationReq.setExtendParams("");

        Map<String, Object> response = BasePayClient.request(refundApplicationReq);
        System.out.println(response);
    }
}