package com.allinpay.ystpay.sample.v1.trans;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.allinpay.ystpay.sample.init.MerConfigDemo;
import com.allinpay.ystpay.sdk.client.BasePayClient;
import com.allinpay.ystpay.sdk.core.request.WeixinPaymentServiceManagementReq;
import com.allinpay.ystpay.sdk.core.utils.SequenceTools;

import java.util.HashMap;
import java.util.Map;

public class WeixinPaymentServiceManagementDemo extends BaseDemo
{
    public static void main(String[] args) throws Exception
    {

        // 1. 数据初始化
        doInit(MerConfigDemo.getMerchantConfig());
        // 构建微信支付分服务单管理（间联模式）
        WeixinPaymentServiceManagementReq weixinPaymentServiceManagementReq = new WeixinPaymentServiceManagementReq();
        //请求流水号
        weixinPaymentServiceManagementReq.setReqTraceNum(SequenceTools.getReqSeqId32());
        // 收银宝商户号
        weixinPaymentServiceManagementReq.setVspCusid("56352105541K2LT");
        // 服务单操作类型
        weixinPaymentServiceManagementReq.setOpType("5");
        // 服务ID
        weixinPaymentServiceManagementReq.setServiceId("00003004000000166634214238830274");
        // 业务参数 各操作类型对应的业务参数
        weixinPaymentServiceManagementReq.setBizParam(getServiceAddBizParam());
        Map<String, Object> response = BasePayClient.request(weixinPaymentServiceManagementReq);
        System.out.println(response);
    }
    // 创建服务单业务参数
    static String getServiceAddBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("outOrderNo", SequenceTools.getReqSeqId32());
        bizData.put("serviceIntroduction", "测试服务单创建");
        JSONArray postPayments = new JSONArray();
        JSONObject payment = new JSONObject();
        payment.put("name", "服务费");
        payment.put("amount", new Long(0));
        payment.put("description", "免费");
        payment.put("count", new Long(10));
        postPayments.add(payment);
        bizData.put("postPayments", postPayments);
//        JSONArray postDiscounts = new JSONArray();
//        JSONObject discount = new JSONObject();
//        discount.put("name", "服务费");
//        discount.put("amount", new Long(0));
//        discount.put("description", "免费");
//        discount.put("count", new Long(10));
//        postDiscounts.add(discount);
//        bizData.put("postDiscounts", postDiscounts);
        JSONObject riskFund = new JSONObject();
        riskFund.put("name", "DEPOSIT");
        riskFund.put("amount", new Long(1));
        bizData.put("riskFund", riskFund);
        JSONObject timeRange = new JSONObject();
        timeRange.put("startTime", "20240831");
        bizData.put("timeRange", timeRange);
        bizData.put("notifyUrl", "http://www.baidu.com");
        bizData.put("attach", "abcdefgfff");
        bizData.put("subAppId","wx445807312554c3c2");
        bizData.put("subOpenId","12345");
        return JSONObject.toJSONString(bizData);
    }

    // 查询服务单业务参数
    static String getServiceGetBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("query_id", "X_5541K2LT202408261028569890");
        bizData.put("outOrderNo", "202408291726211918");
        return JSONObject.toJSONString(bizData);
    }

    // 修改服务单金额业务参数
    static String getServiceModifyBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("outOrderNo", "202408261028569890");
        JSONArray postPayments = new JSONArray();
        JSONObject payment = new JSONObject();
        payment.put("name", "服务费");
        payment.put("amount", new Long(1));
        payment.put("description", "免费");
        payment.put("count", new Long(10));
        postPayments.add(payment);
        bizData.put("postPayments", postPayments);
//        JSONArray postDiscounts = new JSONArray();
//        JSONObject discount = new JSONObject();
//        discount.put("name", "服务费");
//        discount.put("amount", 0);
//        discount.put("description", "免费");
//        discount.put("count", 10);
//        postDiscounts.add(discount);
//        bizData.put("postDiscounts", postDiscounts);
        bizData.put("totalAmount", new Long(10));
        bizData.put("reason", "服务费涨价");
        return JSONObject.toJSONString(bizData);
    }

    // 取消服务单业务参数
    static String getServiceCancelBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("outOrderNo", "202408261028569890");
        bizData.put("reason", "不想要了啊");
        return JSONObject.toJSONString(bizData);
    }

     //完结服务单业务参数
    static String getServiceCompleteBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("outOrderNo", "202408191051018552");
        JSONArray postPayments = new JSONArray();
        JSONObject payment = new JSONObject();
        payment.put("name", "服务费");
        payment.put("amount", new Long(1));
        payment.put("description", "免费");
        payment.put("count", new Long(10));
        postPayments.add(payment);
        bizData.put("postPayments", postPayments);
        JSONArray postDiscounts = new JSONArray();
        JSONObject discount = new JSONObject();
        discount.put("name", "服务费");
        discount.put("amount", new Long(1));
        discount.put("description", "免费");
        discount.put("count", new Long(10));
        postDiscounts.add(discount);
        bizData.put("postDiscounts", postDiscounts);
        bizData.put("totalAmount", new Long(1));
        bizData.put("completeTime", "2024-08-19T11:19:05+08:00");
        return JSONObject.toJSONString(bizData);
    }

     //预授权
    static String getServicepermissionsaddBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("authorizationCode", "1234323JKHDFE1243252");
        bizData.put("subAppid","123");
        bizData.put("notifyUrl", "http://www.baidu.com");
        return JSONObject.toJSONString(bizData);
    }
    // 预授权查询
    static String getServicepermissionsgetBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("authorizationCode", "202408191051018552");
        return JSONObject.toJSONString(bizData);
    }

    // 解除预授权
    static String getServicepermissionsdelBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("authorizationCode", "202408191051018552");
        bizData.put("reason","其他");
        return JSONObject.toJSONString(bizData);
    }

    // 服务单同步业务参数
    static String getServiceSyncBizParam() {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("outOrderNo", "202408261028569890");
        bizData.put("type", "Order_Paid");
        JSONObject detail = new JSONObject();
        detail.put("paidTime", "20240819");
        bizData.put("detail", detail);
        return JSONObject.toJSONString(bizData);
    }
}
